--[[---------------------------------------------------------------------------
	Chocolatier Two Recipe Book
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local item = gRecipeSelection
if not item then return nil end

-------------------------------------------------------------------------------

local yIngList = 132
local trayR = 75
local trayScale = trayR / 75
local slotR = 50 * trayScale

local ingredients
if item.known then
	local x = 2 * trayR
	local y = yIngList -- + bsgFontHeight(recipeFont)
--	ingredients = { Text { x=2*trayR,y=yIngList,w=ui.rbWidth-2*trayR,h=20,label=LabelString("recipe_requires") }, }
	ingredients = {}
	
	x = x + 10
	
--	local ingSize = 2*trayR / 7
	local ingSize = 2*trayR / item.recipeSize
	local ingScale = ingSize / ui.itemHeight
	if ingScale > 1 then
		ingScale = 1
		ingSize = ui.itemHeight
	end
	
	local ingredientFont = { recipeFont[1], recipeFont[2] * ingScale, recipeFont[3] }
	
	local tray = {}
	local total = 0
	for ingName,count in pairs(item.recipe) do
		local ing = LItem:ByName(ingName)
		for n = 1,count do
			-- Place ingredients in the template
			local angle = total * 360 / item.recipeSize
			local tx = trayR + slotR * bsgSin(angle) - ui.itemWidth/2
			local ty = trayR - slotR * bsgCos(angle) - ui.itemHeight/2
			table.insert(tray, ing:Rollover(tx,ty))
		
			table.insert(ingredients, ing:Rollover(x,y,ingScale))
			if ing.inventory < count then
				local s = ingSize/43
				local x1 = x + (ingSize - s * 36) / 2
				table.insert(ingredients, Bitmap { x=x1,y=y,image="image/missed_ingredient", scale=s })
			end
			
			table.insert(ingredients, Text { x=x+ingSize+2,y=y,w=kMax,h=ingSize,
				font=ingredientFont, flags=kVAlignCenter+kHAlignLeft, label=LabelString(ing.name) })
			y = y + ingSize
			total = total + 1
		end
	end
	
	table.insert(ingredients,
		Bitmap { x=0,y=yIngList, image="image/tray"..tostring(item.recipeSize), scale=trayScale, Group(tray) })

--[[
	if gCurrentFactory then
		table.insert(ingredients, TextButton { x=120,y=yIngList+139,		--y=307,
				label=LabelString("select_recipe"), font=standardFont,
				command = function() CloseWindow(gRecipeSelection) end, })
	end
]]--
elseif item.lab then
	ingredients = {
		Text { x=0,y=yIngList,w=ui.rbWidth,h=100,label=LabelString("lab_recipe_unknown") }
	}
else
	ingredients = {
		Text { x=0,y=yIngList,w=ui.rbWidth,h=100,label=LabelString("recipe_unknown") }
	}
end

-------------------------------------------------------------------------------
-- Find the best configuration for this recipe

local configString = nil

if gCurrentFactory then
	local config = gCurrentFactory.config[item.name]
	if config and config > 0 then configString = GetString("current_config", tostring(config)) end
end
if not configString then
	local best = 0
	local bestFactory = nil
	for f in LFactory:AllFactories() do
		if f.config[item.name] and f.config[item.name] > best then
			best = f.config[item.name]
			bestFactory = f
		end
	end
	if bestFactory and best > 0 then configString = GetString("best_config", GetString(bestFactory.port.name), tostring(best)) end
end

if configString then
	local y = yIngList + 2*trayR + 2
	table.insert(ingredients, Text { x=0,y=y,w=ui.rbWidth,h=bsgFontHeight(recipeFont),label="#"..configString })
end

-------------------------------------------------------------------------------

local nameX = ui.itemWidth*2+2

local name = item.name
local desc = item.name.."_desc"
if item.lab and not item.known then
	name = "lab_unknown_recipe"
	desc = "lab_unknown_desc"
end

item.newrecipe = nil

local imageName = "item/"..item.name.."_big"
if item.lab and (not item.known) then imageName = "item/unknown_big" end

MakeDialog
{
	AppendStyle { font=recipeFont },
	Rollover {
		x=0,y=0, fit=true,
		contents=item:RolloverTarget(),
		Bitmap { x=0,y=0, image=imageName, },
		Text { x=nameX,y=0,w=ui.rbWidth-nameX,h=80, label=LabelString(name), font=recipeTitleFont },
	},
	
	Text { x=0,y=75,w=ui.rbWidth,h=62,label=LabelString(desc), flags=kVAlignTop+kHAlignCenter, },
	Group(ingredients),
}
